#include "digirule2.h"

#if SAMPLE_PROGRAMS

static const uint8 sample_programs[8][256] __at( FILE_ADDR ) =
{
	// Program 0 - "KILL THE BIT"
	{
		SPEED, 32,
		COPYLR, 1, DataLEDRegAddr,

		SHIFTRL, DataLEDRegAddr,					// 5
		COPYRA, ButtonRegAddr,
		XORRA, DataLEDRegAddr,
		COPYAR, DataLEDRegAddr,
		JUMP, 5,
	},
	
	// Program 1 - "POV SMILEY FACE"
	{
		INITSP,										// 0
		SPEED, 1,
#if LEGACY_ADDRPC
		COPYLR, 2, 240,
#else
		COPYLR, 0, 240,
#endif

		CALL, 32,									// 6
		COPYAR, DataLEDRegAddr,
		COPYRA, 240,
		ADDLA, 2,
		COPYAR, 240,
		JUMP, 6,
				
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	// 18, padding

		ADDRPC, 240,								// 32
		RETLA, 126,
		RETLA, 129,
		RETLA, 165,
		RETLA, 129,
		RETLA, 165,
		RETLA, 153,
		RETLA, 129,
		RETLA, 126,
		NOP,
#if LEGACY_ADDRPC
		COPYLR, 2, 240,
#else
		COPYLR, 0, 240,
#endif
		JUMP, 32,
	},
	
	// Program 2 - "8-BIT COUNTER"
	{
		SPEED, 130,
		COPYLR, 0, DataLEDRegAddr,

		INCR, DataLEDRegAddr,						// 5
		JUMP, 5,
	},
	
	// Program 3 - "16-BIT COUNTER"
	{
		SPEED, 13,
		SBR, 2, StatusRegAddr,
		COPYLR, 0, DataLEDRegAddr,
		COPYLR, 0, AddressLEDRegAddr,

		INCRJZ, DataLEDRegAddr,						// 11
		JUMP, 11,

		INCR, AddressLEDRegAddr,
		JUMP, 11,
	},
	
	// Program 4 - "KNIGHTRIDER"
	{
		SPEED, 20,
		COPYLR, 1, DataLEDRegAddr,

		SHIFTRL, DataLEDRegAddr,					// 5
		BCRSS, 7, DataLEDRegAddr,
		JUMP, 5,

		SHIFTRR, DataLEDRegAddr,					// 12
		BCRSS, 0, DataLEDRegAddr,
		JUMP, 12,

		JUMP, 5,
	},
	
	// Program 5 - "BUTTON TEST"
	{
		SPEED, 1,

		COPYRR, ButtonRegAddr, DataLEDRegAddr,		// 2
		JUMP, 2,
	},
	
	// Program 6 - "TARGET PRACTICE"
	{
		INITSP,										// 0
		SPEED, 17,
		SBR, 2, StatusRegAddr,
		COPYLR, 0, AddressLEDRegAddr,
		COPYLR, 1, DataLEDRegAddr,

		SHIFTRL, DataLEDRegAddr,					// 12
		CALL, 32,
		BCRSS, 7, DataLEDRegAddr,
		JUMP, 12,

		SHIFTRR, DataLEDRegAddr,					// 21
		CALL, 32,
		BCRSS, 0, DataLEDRegAddr,
		JUMP, 21,

		JUMP, 12,

		COPYRA, ButtonRegAddr,						// 32
		ADDLA, 0,
		BCRSC, 0, StatusRegAddr,
		RETURN,
		0,											// padding

		ANDRA, DataLEDRegAddr,
		BCRSC, 0, StatusRegAddr,
		JUMP, 0,

		INCR, AddressLEDRegAddr,
		RETURN,
	},
	
	// Program 7 - "POLICE FLASHER"
	{
		SPEED, 162,
		SBR, 2, StatusRegAddr,

		COPYLR, 15, DataLEDRegAddr,					// 5
		COPYLR, 240, DataLEDRegAddr,
		NOP,										// for loop symmetry

		COPYLR, 15, AddressLEDRegAddr,
		COPYLR, 240, AddressLEDRegAddr,
		JUMP, 5,
	},
};

#endif
